/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.export.csv;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import cz.insophy.inplan.export.csv.CsvFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvFormatSerializer {
    private static final Logger log = LoggerFactory.getLogger(CsvFormatSerializer.class);
    private static final JsonFactory FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER = new ObjectMapper(FACTORY);

    public static void serialize(OutputStream os, CsvFormat format) throws IOException {
        try (JsonGenerator gen = FACTORY.createGenerator(os);){
            gen.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
            gen.writeObject(format);
        }
    }

    public static CsvFormat deserialize(InputStream is) throws IOException {
        try (JsonParser parser = FACTORY.createParser(is);){
            parser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            CsvFormat csvFormat = MAPPER.readValue(parser, CsvFormat.class);
            return csvFormat;
        }
    }

    static {
        MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        MAPPER.addHandler(new DeserializationProblemHandler(){

            @Override
            public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser p, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
                p.skipChildren();
                log.warn("Unknown property {} in csv format JSON", (Object)propertyName);
                return true;
            }
        });
    }
}

